function [dxi,dy_int,xi,y_int,y_minus,y_plus] = ...
    fault_slip_compute_xi(flag_merged,n_int,y_a,y_minus,y_plus)
%
% Computes the vectors y_int and xi of grid points for numerical integration, where xi is a
% shifted version of y_int such that the singular points y_int = xi and xi = y_a are avoided,
% with y_minus < y_a < y_plus. If flag_merged == 0, y_a = -a or y_a = a; if flag_merged == 1,
% y_a = [-a a].
%                                                               

n_minus_1 = n_int(2); % target number of integration points below y_a (unmerged case)
n_plus_1  = n_int(4); % target number of integration points above y_a (unmerged case)
n_minus_2 = n_int(3); % target number of integration points below -a (merged case)
n_mid     = n_int(1); % target nr. of integr. points in-between y = -a and y = a (merged case)
n_plus_2  = n_int(5); % target number of integration points above a (merged case)

if flag_merged == 0 % slip patches have not yet merged
    % Segment y_min to y_a:
    if y_a < y_minus
        y_minus = y_a;
    end
    help = linspace(y_minus,y_a,2*n_minus_1); % double point density
    y_int_minus = help(3:2:end-2); % y_minus and y_a excluded
    xi_minus = help(2:2:end-1); % all points shifted over half interval compared to y_int_minus
    Delta_minus = y_int_minus(2)-y_int_minus(1);
    
    % Segment y_a to y_plus:
    if y_plus < y_a
        y_plus = y_a;
    end
    help = linspace(y_a,y_plus,2*n_plus_1); % double point density
    y_int_plus = help(3:2:end-2); % y_a and y_plus excluded
    xi_plus = help(2:2:end-1); % all points shifted over half interval compared to y_int_plus
    Delta_plus = y_int_plus(2)-y_int_plus(1);
    
    % Compute integration points:
    y_int = [y_int_minus y_int_plus]; % note: y_a is missing
    dy_int = [1.5*Delta_minus ones(1,n_minus_1-4)*Delta_minus 1.5*Delta_minus ...
        1.5*Delta_plus ones(1,n_plus_1-4)*Delta_plus 1.5*Delta_plus];
    xi = [xi_minus xi_plus];
    dxi = [ones(1,n_minus_1-1)*Delta_minus ones(1,n_plus_1-1)*Delta_plus];

else % slip patches have merged
    % Segment y_min to -a:
    if y_a(1) < y_minus
        y_minus = y_a(1);
    end
    help = linspace(y_minus,y_a(1),2*n_minus_2); % double point density
    y_int_minus = help(3:2:end-2); % y_minus and y_a excluded
    xi_minus = help(2:2:end-1); % all points shifted over half interval compared to y_int_minus
    Delta_minus = y_int_minus(2)-y_int_minus(1);
    
    % Segment a to y_plus:
    if y_plus < y_a(2)
        y_plus = y_a(2);
    end
    help = linspace(y_a(2),y_plus,2*n_plus_2); % double point density
    y_int_plus = help(3:2:end-2); % y_a and y_plus excluded
    xi_plus = help(2:2:end-1); % all points shifted over half interval compared to y_int_plus
    Delta_plus = y_int_plus(2)-y_int_plus(1);
    
    % Segment -a to a:
    help = linspace(y_a(1),y_a(2),2*n_mid); % double point density
    y_int_mid = help(3:2:end-2); % y_a(1) and y_a(2) excluded
    xi_mid = help(2:2:end-1); % all points shifted over half interval compared to y_int_mid
    Delta_mid = y_int_mid(2)-y_int_mid(1);
    
    % Compute integration points:
    y_int = [y_int_minus y_int_mid y_int_plus]; % note: y_a(1) = -a and y_a(2) = a are missing
    dy_int = [1.5*Delta_minus ones(1,n_minus_2-4)*Delta_minus 1.5*Delta_minus ...
        1.5*Delta_mid ones(1,n_mid-4)*Delta_mid 1.5*Delta_mid ...
        1.5*Delta_plus ones(1,n_plus_2-4)*Delta_plus 1.5*Delta_plus];
    xi = [xi_minus xi_mid xi_plus];
    dxi = [ones(1,n_minus_2-1)*Delta_minus ones(1,n_mid-1)*Delta_mid ...
        ones(1,n_plus_2-1)*Delta_plus];    
end